/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.connected.update;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.rule.RuleKey;
import org.sonarqube.ws.QualityProfiles;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.WsResponse;
import org.sonarsource.sonarlint.core.container.connected.SonarLintWsClient;
import org.sonarsource.sonarlint.core.container.storage.ProtobufUtil;
import org.sonarsource.sonarlint.core.proto.Sonarlint;
import org.sonarsource.sonarlint.core.util.FileUtils;

public class RulesDownloader {
    private static final String RULES_SEARCH_URL = "/api/rules/search.protobuf?f=repo,name,severity,lang,internalKey,isTemplate,templateKey,htmlDesc,mdDesc,actives&statuses=BETA,DEPRECATED,READY";
    private static final String DEFAULT_QP_SEARCH_URL = "/api/qualityprofiles/search.protobuf?defaults=true";
    private final SonarLintWsClient wsClient;

    public RulesDownloader(SonarLintWsClient wsClient) {
        this.wsClient = wsClient;
    }

    public void fetchRulesTo(Path destDir) {
        Sonarlint.Rules.Builder rulesBuilder = Sonarlint.Rules.newBuilder();
        HashMap<String, Sonarlint.ActiveRules.Builder> activeRulesBuildersByQProfile = new HashMap<String, Sonarlint.ActiveRules.Builder>();
        this.fetchRulesAndActiveRules(rulesBuilder, activeRulesBuildersByQProfile);
        Path activeRulesDir = destDir.resolve("active_rules");
        FileUtils.forceMkDirs(activeRulesDir);
        for (Map.Entry entry : activeRulesBuildersByQProfile.entrySet()) {
            rulesBuilder.getMutableQprofilesByKey().put((String)entry.getKey(), Sonarlint.Rules.QProfile.newBuilder().setKey((String)entry.getKey()).build());
            ProtobufUtil.writeToFile(((Sonarlint.ActiveRules.Builder)entry.getValue()).build(), activeRulesDir.resolve((String)entry.getKey() + ".pb"));
        }
        try (InputStream contentStream = this.wsClient.get(DEFAULT_QP_SEARCH_URL).contentStream();){
            QualityProfiles.SearchWsResponse qpResponse = QualityProfiles.SearchWsResponse.parseFrom(contentStream);
            for (QualityProfiles.SearchWsResponse.QualityProfile qp : qpResponse.getProfilesList()) {
                rulesBuilder.getMutableDefaultQProfilesByLanguage().put(qp.getLanguage(), qp.getKey());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load default quality profiles", e);
        }
        ProtobufUtil.writeToFile(rulesBuilder.build(), destDir.resolve("rules.pb"));
    }

    private void fetchRulesAndActiveRules(Sonarlint.Rules.Builder rulesBuilder, Map<String, Sonarlint.ActiveRules.Builder> activeRulesBuildersByQProfile) {
        int page = 1;
        int pageSize = 500;
        int loaded = 0;
        while (true) {
            Rules.SearchResponse response = RulesDownloader.loadFromStream(this.wsClient.get(RulesDownloader.getUrl(page, pageSize)));
            RulesDownloader.readPage(rulesBuilder, activeRulesBuildersByQProfile, response);
            loaded = (int)((long)loaded + response.getPs());
            if (response.getTotal() <= (long)loaded) break;
            ++page;
        }
    }

    private static String getUrl(int page, int pageSize) {
        StringBuilder builder = new StringBuilder(1024);
        builder.append(RULES_SEARCH_URL);
        builder.append("&p=").append(page);
        builder.append("&ps=").append(pageSize);
        return builder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Rules.SearchResponse loadFromStream(WsResponse response) {
        try (InputStream is = response.contentStream();){
            Rules.SearchResponse searchResponse = Rules.SearchResponse.parseFrom(is);
            return searchResponse;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load rules", e);
        }
    }

    private static void readPage(Sonarlint.Rules.Builder rulesBuilder, Map<String, Sonarlint.ActiveRules.Builder> activeRulesBuildersByQProfile, Rules.SearchResponse response) {
        Sonarlint.Rules.Rule.Builder ruleBuilder = Sonarlint.Rules.Rule.newBuilder();
        for (Rules.Rule r : response.getRulesList()) {
            ruleBuilder.clear();
            RuleKey ruleKey = RuleKey.parse(r.getKey());
            rulesBuilder.getMutableRulesByKey().put(r.getKey(), ruleBuilder.setRepo(ruleKey.repository()).setKey(ruleKey.rule()).setName(r.getName()).setSeverity(r.getSeverity()).setLang(r.getLang()).setInternalKey(r.getInternalKey()).setHtmlDesc(r.getHtmlDesc()).setIsTemplate(r.getIsTemplate()).setTemplateKey(r.getTemplateKey()).build());
        }
        Sonarlint.ActiveRules.ActiveRule.Builder arBuilder = Sonarlint.ActiveRules.ActiveRule.newBuilder();
        for (Map.Entry<String, Rules.ActiveList> entry : response.getActives().getActives().entrySet()) {
            RuleKey ruleKey = RuleKey.parse(entry.getKey());
            for (Rules.Active ar : entry.getValue().getActiveListList()) {
                String qProfileKey = ar.getQProfile();
                if (!activeRulesBuildersByQProfile.containsKey(qProfileKey)) {
                    activeRulesBuildersByQProfile.put(qProfileKey, Sonarlint.ActiveRules.newBuilder());
                }
                arBuilder.clear();
                arBuilder.setRepo(ruleKey.repository());
                arBuilder.setKey(ruleKey.rule());
                arBuilder.setSeverity(ar.getSeverity());
                for (Rules.Active.Param p : ar.getParamsList()) {
                    arBuilder.getMutableParams().put(p.getKey(), p.getValue());
                }
                activeRulesBuildersByQProfile.get(qProfileKey).getMutableActiveRulesByKey().put(entry.getKey(), arBuilder.build());
            }
        }
    }
}

